create or replace package body tbicds.PCK_REFERRAL_CLINIC is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
   /*
   get referral clinic recordset
   */
   procedure GetReferralClinicRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nStatReferralID  in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select * from tbicds.stat_referral where stat_referral_id = :P0 ';
      open rs for v_vSql using pi_nStatReferralID;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_REFERRAL_CLINIC.GetReferralClinicRS(): ' || sqlErrm;
   end;

   /*
   Get referral clinic lookup recordset
   */
   procedure GetReferralClinicLookUpRS(pi_vSessionID       in varchar2,
                                      pi_vSessionClientIP in varchar2,
                                      pi_nUserID          in number,
                                      po_nStatusCode      out number,
                                      po_vStatusComment   out varchar2,
                                      rs                  out RetRefCursor) 
   is
      strSQL varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      strSQL := 'select t.* from tbicds.stat_referral t where t.active = 1';
      open rs for strSQL;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_REFERRAL_CLINIC.GetReferralClinicLookUpRS(): ' || sqlErrm;
   end;

   /*
   Insert a referral clinic
   */
   procedure InsertReferralClinic(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_vReferralDesc    in varchar2,
                                 pi_vReferralText    in varchar2,
                                 pi_vProviderName in varchar2,
                                 pi_vAddress      in varchar2,
                                 pi_vCity         in varchar2,
                                 pi_nStateID      in number,
                                 pi_vPostalCode   in varchar2,
                                 pi_vPhone        in varchar2,
                                 pi_vFax          in varchar2,
                                 po_nReferralID    out number,
                                 po_nStatusCode    out number,
                                 po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
      v_nReferralID number;
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      po_nReferralID    := -1;
   
      --get a new encounter_intake_id
      v_vSql := 'select tbicds.SEQREFERRALID.Nextval from dual';
      execute immediate v_vSql into v_nReferralID;
      
      v_vSql := 'insert into tbicds.stat_referral ('
                || 'stat_referral_id, stat_referral_desc, stat_referral_text, provider_name, street_address, '
                || 'city, state, postal_code, phone, fax) '
                || 'values ('
                || ':P0, :P1, :P2, :P3, :P4, :P5, :P6, :P7, :P8, :P9) ';
      execute immediate v_vSql using 
         v_nReferralID, pi_vReferralDesc, pi_vReferralText, pi_vProviderName, pi_vAddress,
         pi_vCity, pi_nStateID, pi_vPostalCode, pi_vPhone, pi_vFax;
      commit;
      
      po_nReferralID := v_nReferralID;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_REFERRAL_CLINIC.InsertReferralClinic(): ' || sqlErrm;
   end;

   /*
   Update a referral clinic
   */
   procedure UpdateReferralClinic(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_nReferralID      in number,
                                 pi_vReferralDesc    in varchar2,
                                 pi_vReferralText    in varchar2,
                                 pi_vProviderName in varchar2,
                                 pi_vAddress      in varchar2,
                                 pi_vCity         in varchar2,
                                 pi_nStateID      in number,
                                 pi_vPostalCode   in varchar2,
                                 pi_vPhone        in varchar2,
                                 pi_vFax          in varchar2,
                                 po_nStatusCode    out number,
                                 po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.stat_referral set '
                || 'stat_referral_desc = :P0, '
                || 'stat_referral_text = :P1, '
                || 'provider_name = :P2, '
                || 'street_address = :P3, '
                || 'city = :P4, '
                || 'state = :P5, '
                || 'postal_code = :P6, '
                || 'phone = :P7, '
                || 'fax = :P8 '
                || 'where stat_referral_id = :P9 ';
      execute immediate v_vSql using
         pi_vReferralDesc, pi_vReferralText, pi_vProviderName, pi_vAddress, pi_vCity,
         pi_nStateID, pi_vPostalCode, pi_vPhone, pi_vFax, pi_nReferralID;
      commit;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_REFERRAL_CLINIC.UpdateReferralClinic(): ' || sqlErrm;
   end;

   /*
   Discontinue a referral clinic
   */
   procedure DiscontinueReferralClinic(pi_vSessionID       in varchar2,
                                      pi_vSessionClientIP in varchar2,
                                      pi_nUserID          in number,
                                      pi_nReferralID      in number,
                                      po_nStatusCode      out number,
                                      po_vStatusComment   out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.stat_referral set active = 0 where stat_referral_id = :P0 ';
      execute immediate v_vSql using pi_nReferralID;
      commit;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_REFERRAL_CLINIC.DiscontinueReferralClinic(): ' || sqlErrm;
   end;

end;
/

